/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 2001 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 * Contributor(s):
 *  Bob Lord <lord@netscape.com>
 *  Ian McGreer <mcgreer@netscape.com>
 */

const nsIX509Cert = Components.interfaces.nsIX509Cert;
const nsX509CertDB = "@mozilla.org/security/x509certdb;1";
const nsIX509CertDB = Components.interfaces.nsIX509CertDB;
const nsIPKIParamBlock = Components.interfaces.nsIPKIParamBlock;

var certdb;
var cert;

function setWindowName()
{
  var dbkey = self.name;

  //  Get the cert from the cert database
  certdb = Components.classes[nsX509CertDB].getService(nsIX509CertDB);
  //var pkiParams = window.arguments[0].QueryInterface(nsIPKIParamBlock);
  //var isupport = pkiParams.getISupportAtIndex(1);
  //cert = isupport.QueryInterface(nsIX509Cert);
  cert = certdb.findCertByDBKey(dbkey, null);

  var bundle = srGetStrBundle("chrome://pippki/locale/pippki.properties");
  var windowReference = document.getElementById('editCaCert');

  var message1 = bundle.formatStringFromName("editTrustCA",
                                             [ cert.commonName ],
                                             1);
  setText("certmsg", message1);

  var ssl = document.getElementById("trustSSL");
  if (certdb.isCertTrusted(cert, nsIX509Cert.CA_CERT, 
                          nsIX509CertDB.TRUSTED_SSL)) {
    ssl.setAttribute("checked", "true");
  } else {
    ssl.setAttribute("checked", "false");
  }
  var email = document.getElementById("trustEmail");
  if (certdb.isCertTrusted(cert, nsIX509Cert.CA_CERT, 
                          nsIX509CertDB.TRUSTED_EMAIL)) {
    email.setAttribute("checked", "true");
  } else {
    email.setAttribute("checked", "false");
  }
  var objsign = document.getElementById("trustObjSign");
  if (certdb.isCertTrusted(cert, nsIX509Cert.CA_CERT,  
                          nsIX509CertDB.TRUSTED_OBJSIGN)) {
    objsign.setAttribute("checked", "true");
  } else {
    objsign.setAttribute("checked", "false");
  }
  
  window.sizeToContent();
}

function doOK()
{
  var ssl = document.getElementById("trustSSL");
  var email = document.getElementById("trustEmail");
  var objsign = document.getElementById("trustObjSign");
  var trustssl = (ssl.checked) ? nsIX509CertDB.TRUSTED_SSL : 0;
  var trustemail = (email.checked) ? nsIX509CertDB.TRUSTED_EMAIL : 0;
  var trustobjsign = (objsign.checked) ? nsIX509CertDB.TRUSTED_OBJSIGN : 0;
  //
  //  Set the cert trust
  //
  certdb.setCertTrust(cert, nsIX509Cert.CA_CERT, 
                      trustssl | trustemail | trustobjsign);
  window.close();
}

function doLoadForSSLCert()
{
  var dbkey = self.name;

  //  Get the cert from the cert database
  certdb = Components.classes[nsX509CertDB].getService(nsIX509CertDB);
  cert = certdb.findCertByDBKey(dbkey, null);

  var bundle = srGetStrBundle("chrome://pippki/locale/pippki.properties");
  var windowReference = document.getElementById('editWebsiteCert');

  var message1 = bundle.formatStringFromName("editTrustSSL",
                                             [ cert.commonName ],
                                             1);
  setText("certmsg", message1);

  setText("issuer", cert.issuerName);

  var cacert = getCaCertForEntityCert(cert);
  if(cacert == null)
  {
     setText("explainations",bundle.GetStringFromName("issuerNotKnown"));
  }
  else if(certdb.isCertTrusted(cacert, nsIX509Cert.CA_CERT,
                                                nsIX509CertDB.TRUSTED_SSL))
  {
     setText("explainations",bundle.GetStringFromName("issuerTrusted"));
  }
  else
  {
     setText("explainations",bundle.GetStringFromName("issuerNotTrusted"));
  }
/*
  if(cacert == null)
  {
     var editButton = document.getElementById('editca-button');
	 editButton.setAttribute("disabled","true");
  }
*/  
  var trustssl = document.getElementById("trustSSLCert");
  var notrustssl = document.getElementById("dontTrustSSLCert");
  if (certdb.isCertTrusted(cert, nsIX509Cert.SERVER_CERT, 
                          nsIX509CertDB.TRUSTED_SSL)) {
    trustssl.radioGroup.selectedItem = trustssl;
  } else {
    trustssl.radioGroup.selectedItem = notrustssl;
  }
  
  window.sizeToContent();
}

function doSSLOK()
{
  var ssl = document.getElementById("trustSSLCert");
  //var checked = ssl.getAttribute("value");
  var trustssl = ssl.selected ? nsIX509CertDB.TRUSTED_SSL : 0;
  //
  //  Set the cert trust
  //
  certdb.setCertTrust(cert, nsIX509Cert.SERVER_CERT, trustssl);
  window.close();
}

function doLoadForEmailCert()
{
  var dbkey = self.name;

  //  Get the cert from the cert database
  certdb = Components.classes[nsX509CertDB].getService(nsIX509CertDB);
  cert = certdb.findCertByDBKey(dbkey, null);

  var bundle = srGetStrBundle("chrome://pippki/locale/pippki.properties");
  var windowReference = document.getElementById('editEmailCert');

  var message1 = bundle.formatStringFromName("editTrustEmail",
                                             [ cert.commonName ],
                                             1);
  setText("certmsg", message1);

  setText("issuer", cert.issuerName);

  var cacert = getCaCertForEntityCert(cert);
  if(cacert == null)
  {
     setText("explainations",bundle.GetStringFromName("issuerNotKnown"));
  }
  else if(certdb.isCertTrusted(cacert, nsIX509Cert.CA_CERT,
                                                nsIX509CertDB.TRUSTED_EMAIL))
  {
     setText("explainations",bundle.GetStringFromName("issuerTrusted"));
  }
  else
  {
     setText("explainations",bundle.GetStringFromName("issuerNotTrusted"));
  }
/*
  if(cacert == null)
  {
     var editButton = document.getElementById('editca-button');
	 editButton.setAttribute("disabled","true");
  }
*/  
  var trustemail = document.getElementById("trustEmailCert");
  var notrustemail = document.getElementById("dontTrustEmailCert");
  if (certdb.isCertTrusted(cert, nsIX509Cert.EMAIL_CERT, 
                          nsIX509CertDB.TRUSTED_EMAIL)) {
    trustemail.radioGroup.selectedItem = trustemail;
  } else {
    trustemail.radioGroup.selectedItem = notrustemail;
  }
  
  window.sizeToContent();
}

function doEmailOK()
{
  var email = document.getElementById("trustEmailCert");
  //var checked = ssl.getAttribute("value");
  var trustemail = email.selected ? nsIX509CertDB.TRUSTED_EMAIL : 0;
  //
  //  Set the cert trust
  //
  certdb.setCertTrust(cert, nsIX509Cert.EMAIL_CERT, trustemail);
  window.close();
}

function editCaTrust()
{
   var cacert = getCaCertForEntityCert(cert);
   if(cacert != null)
   {
      window.openDialog('chrome://pippki/content/editcacert.xul', cacert.dbKey,
                        'chrome,centerscreen,modal');
   }
   else
   {
      var bundle = srGetStrBundle("chrome://pippki/locale/pippki.properties");
      alert(bundle.GetStringFromName("issuerCertNotFound"));
   }
}

function getCaCertForEntityCert(cert)
{
   var i=1;
   var nextCertInChain;
   nextCertInChain = cert;
   var lastSubjectName="";
   while(true)
   {
     if(nextCertInChain == null)
     {
        return null;
     }
     if((nextCertInChain.type == nsIX509Cert.CA_CERT) || 
                                 (nextCertInChain.subjectName = lastSubjectName))
     {
        break;
     }

     lastSubjectName = nextCertInChain.subjectName;
     nextCertInChain = nextCertInChain.issuer;
   }

   return nextCertInChain;
}

